C     FORTRAN code: Not used in main text
C     File: multi-step.for
C
C     PROGRAM FOR COMPUTING THE APPROXIMATE MULTI-STEP   
C     AHEAD FORECASTS
C     RESULTS FROM MOEANADDIN'S PAPER AND FOR THE CORRECTED FORMULA        
C
C     Reference:
C     De Gooijer, J.G. and Kumar, K. (1992).
C       Some recent developments in non-linear time series modelling, 
C       testing, and forecasting.
C       International Journal of Forecasting, 8(2), 135-156.
C       Corrigendum: IJF, 9 (1993), p. 145.
c       DOI: 10.1016/0169-2070(92)90115-P.
C     **********************************************************************    
C
      IMPLICIT REAL (A-H,O-Z)      
      REAL Z(30),SZ(30),SZ2(30)
      REAL Y(30),SY(30),SY2(30)
      REAL PZ(30),QZ(30),FIZ,SQPI,PI
      INTEGER H
C
      CHARACTER*50 FILE2,FILE4
C
C     **********     START INPUT SECTION          **********************
C
      FILE4='CON'
      OPEN(*,FILE='USER')
      OPEN(7,FILE=FILE4)
C
C     *********  PARAMETERS  ********
c
      DO 100 I=1,5
      WRITE(7,*)
 100  CONTINUE
      WRITE(7,*) '****************************************************'
      WRITE(7,*)
      WRITE(7,*) ' THIS PROGRAM COMPUTES THE APPROXIMATE MULTI-STEP-  '
      WRITE(7,*) ' AHEAD FORECASTS FOR SETMA(2;1,1) MODELS            '
      WRITE(7,*) '****************************************************'
      WRITE(7,*)
C
 41   CONTINUE
      WRITE(*,'(A)')'  WHAT IS YOUR OUPUT FILE (FORMA.OUT) ? '
      READ(*,'(A)') FILE2
C
      IF (FILE2.EQ.' ') THEN
      FILE2='FORMA.OUT'
      END IF
      OPEN(6,FILE=FILE2)
C
      Z(1)=-4
      Y(1)=-4
C
      SZ2(1)=1
      SY2(1)=1
      SZ(1)=1
      SY(1)=1
      var=1
C
      PI=3.14159265
C
C     PARAMETER VALUES OF THE 
C     THE SETAR(2;1,1) THRESHOLD MODEL SPECIFIED BY MOEANNADDIN
C     WITH CONSTANTS AA0 AND BB0
C
C     FOR X{T-1} < 0 :
C
      AA0=0
      AA1=0.5
C
C     FOR X{T-1} > 0 :
C
      BB0=0
      BB1=-0.5
C
      DO 1500 H=2,15
C
C***************************************************************
C     CUMULATIVE PROB OF NORMAL DISTRIBUTION APPROXIMATED
C     P(X < ZZ) FOR VALUES OF ZZ IN THE RANGE 0 <= ZZ < INFTY
C     SEE, E.G. ABRAMOWITZ AND STEGUN  P. 932
C***************************************************************
C
C     THE THRESHOLD C IS FIXED AT ZERO  
C
      a1=.0498673470
      a2=.0211410061
      a3=.0032776263
      a4=.0000380036
      a5=.0000488906
      a6=.0000053830
C
      IF(Z(H-1).LE.0) THEN
         ZZ=-Z(H-1)/SQRT(SZ2(H-1))
         PZ(H-1)=1-0.5*(1+a1*ZZ+a2*ZZ*ZZ+a3*ZZ**3+a4*ZZ**4
     *  +a5*ZZ**5+a6*ZZ**6)**(-16)
        QZ(H-1)=1-PZ(H-1)
      ELSE
         ZZ=Z(H-1)/SQRT(SZ2(H-1))
         QZ(H-1)=1-0.5*(1+a1*ZZ+a2*ZZ*ZZ+a3*ZZ**3+a4*ZZ**4
     *  +a5*ZZ**5+a6*ZZ**6)**(-16)
        PZ(H-1)=1-QZ(H-1)
       ENDIF
C
C****************************************************************
C
      sqpi=sqrt(2*pi)
      FIZ=EXP((-ZZ*ZZ)/2)/SQPI
C
C     MOEANADDIN'S FORMULA (4.1) :
C
      Y(H)=(AA0+AA1*Y(H-1))*PZ(H-1)+(BB0+BB1*Y(H-1))*QZ(H-1)
C
C     THE CORRECTED FORMULA (4.1) (SEE DE GOOIJER AND KUMAR, 1993):
C
       Z(H)=(AA0+AA1*Z(H-1))*PZ(H-1)+(BB0+BB1*Z(H-1))*QZ(H-1)
     1 +(BB1-AA1)*sqrt(SZ2(H-1))*FIZ
C
C     MOEANADDIN'S FORMULA FOR THE VARIANCE; SEE PAGE 9 OF HIS PAPER
C     OR FORMULA (6.6) IN DE GOOIJER AND KUMAR (1992) :
C
      SY2(H)=
     1  (AA0*AA0+AA1*AA1*SY2(H-1)+2*AA0*AA1*Y(H-1)
     2     + AA1*AA1*Y(H-1)*Y(H-1))*PZ(H-1)
     3 +(BB0*BB0+BB1*BB1*SY2(H-1)+2*BB0*BB1*Y(H-1)
     4     + BB1*BB1*Y(H-1)*Y(H-1))*QZ(H-1)
     5 +1-Z(H)*Z(H)
C
C     THE CORRECTED FORMULA FOR THE VARIANCE
C     (SEE DE GOOIJER AND KUMAR, 1993 APPART FROM A MISSING TERM
C     SIGMA^2) :
C
      SZ2(H)=
     1  (AA0*AA0+AA1*AA1*SZ2(H-1)+2*AA0*AA1*Z(H-1)
     2     + AA1*AA1*Z(H-1)*Z(H-1))*PZ(H-1)
     3 +(BB0*BB0+BB1*BB1*SZ2(H-1)+2*BB0*BB1*Z(H-1)
     4     + BB1*BB1*Z(H-1)*Z(H-1))*QZ(H-1)
     5 +var-Z(H)*Z(H)
     6 +(BB1*BB1*SZ2(H-1)*ZZ+2*BB1*SQRT(SZ2(H-1))*(BB0+
     7       BB1*Z(H-1)))*FIZ
     8 -(AA1*AA1*SZ2(H-1)*ZZ+2*AA1*SQRT(SZ2(H-1))*(AA0+
     9       AA1*Z(H-1)))*FIZ

C
       SZ(H)=SQRT(SZ2(H))
       SY(H)=SQRT(SY2(H))
C
 1500 CONTINUE
C
      WRITE(6,*) '      FORECASTS OBTAINED FROM MOEANIDDIN FORMULAE '
      WRITE(6,*) '      AND THE CORRECTED FORMULA '
      WRITE(6,*) ' **************************************************'
      WRITE(6,*) '          H  FOREC.(MOEAN)  FOREC.(CORR)    SD(MOEAN)
     *    SD(CORR)'
      DO 1501 H=1,15
      WRITE(6,*) H, Y(H), Z(H), SY(H), SZ(H)
 1501 CONTINUE
C
      END
